<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    Class VisualizzatoreModuloLogin extends VisualizzatoreComponente {
        private $gestoreTraduzioni;
        private $linguaCorrente;
        
        function __construct($db) {
            parent::__construct($db);
        }
        
        public function generaContenutoSezione($dati) {
            $installazioneAdmin = parent::getDb()->leggiSingolaRiga("geec_prodotti",2);
            
            if($installazioneAdmin["installato"]=="si") {
                $sessioneUtente = isset($_SESSION["geecomUser_id"]) ? $_SESSION["geecomUser_id"] : 0;
                $datiCookie     = parent::getDb()->leggiSingolaRiga("geecB_leggeCookie",1);
                $datiGeecomAdmin = parent::getDb()->leggiSingolaRiga("geecAd_impostazioni",1);
                $this->stampaModuloRegistrazione($sessioneUtente,$datiCookie,$datiGeecomAdmin["urlPiattaforma"]);
            }
            else {
                parent::messaggioDiErrore("Attenzione: <a href=\"https://www.geecom.org/?alias=scarica-geecom\">Geecom Admin</a> non è installato su questo spazio web","");
            }
        }
        
        public function stampaModuloRegistrazione($sessioneUtente,$datiCookie,$percorsoAdmin) {
            $this->datiModuloRegistrazione = parent::getDb()->leggiSingolaRiga("geecAd_moduliRegistrazione",1);
            
            echo"<div class=\"container\">
                    <div class=\"row\">";
                       
                        if($sessioneUtente==0) {
                            $this->stampaModuloLogin($percorsoAdmin);
                        }
                        else {
                            $this->stampaBenvenuto($sessioneUtente);
                        }

		 	echo"<div class=\"col-md-6\">
                            <div class=\"bg-light p-4 box-shadow-lite border\">
                                <h5>Registrati al sito</h5>
                                    <form class=\"mt-3\" name=\"formRegistrazione\" action=\"$percorsoAdmin/utenti/eseguiRegistrazione.php\" method=\"post\">";
                                        
                                        if($this->datiModuloRegistrazione["richiediNome"]=="si") {
                                            echo"<div class=\"form-label-group\">
                                                <input type=\"text\" class=\"form-control\" id=\"nome\" name=\"nome\" placeholder=\"Nome\" value=\"\">
                                                <label for=\"nome\" >Nome</label>
                                            </div>";
                                        }

                                        if($this->datiModuloRegistrazione["richiediCognome"]=="si") {
                                            echo"<div class=\"form-label-group\">
                                                <input type=\"text\" class=\"form-control\" id=\"cognome\" name=\"cognome\" placeholder=\"Cognome\" value=\"\" >
                                                <label for=\"cognome\" >Cognome</label>
                                            </div>";
                                        }

                                        
                                        if($this->datiModuloRegistrazione["richiediOrganizzazione"]=="si") {
		                                echo"<div class=\"form-label-group\">
		                                    <input type=\"text\" class=\"form-control\" id=\"partitaIva\" name=\"organizzazione\" placeholder=\"Ragione sociale\" value=\"\" >
		                                    <label for=\"telefono\" >Organizzazione</label>
		                               </div>";
                                        }
                                        
                                        if($this->datiModuloRegistrazione["richiediCodiceFiscale"]=="si") {
		                                echo"<div class=\"form-label-group\">
		                                    <input type=\"text\" class=\"form-control\" id=\"codiceFiscale\" name=\"codiceFiscale\" placeholder=\"Codice fiscale\" value=\"\" >
		                                    <label for=\"codiceFiscale\" >Codice fiscale</label>
		                               </div>";
                                        }
                                        
                                        if($this->datiModuloRegistrazione["richiediPartitaIva"]=="si") {
		                                echo"<div class=\"form-label-group\">
		                                    <input type=\"text\" class=\"form-control\" id=\"partitaIva\" name=\"partitaIva\" placeholder=\"Partita IVA\" value=\"\" >
		                                    <label for=\"partitaIva\" >Partita IVA</label>
		                               </div>";
                                        }
                                        
                                        if($this->datiModuloRegistrazione["richiediTelefono"]=="si") {
		                                echo"<div class=\"form-label-group\">
		                                    <input type=\"text\" class=\"form-control\" id=\"telefono\" name=\"telefono\" placeholder=\"Telefono\" value=\"\" >
		                                    <label for=\"telefono\" >Telefono</label>
		                               </div>";
                                        }

                                        
                                        echo"<div class=\"form-label-group\">
                                            <input type=\"email\" class=\"form-control\" id=\"email\" name=\"email\" placeholder=\"Email\" value=\"\">
                                            <label for=\"email\" >Email</label>
                                        </div>";

                                        echo"<div class=\"form-label-group\">
                                            <input type=\"password\" class=\"form-control\" id=\"password\" name=\"password\" placeholder=\"Partita IVA\" value=\"\" >
                                            <label for=\"password\">Password</label>
                                        </div>";
                                        
                                        if($this->datiModuloRegistrazione["richiediGruppo"]=="si") {
                                            $queryGruppi = "SELECT * FROM geec_gruppi";
                                            $risGruppi = parent::getDb()->eseguiQueryLettura($queryGruppi);
				        ?>
				            <div class="form-group">
				                <p><?= $this->gestoreTraduzioni->traduci("Seleziona il gruppo di appartenzenza",$this->linguaCorrente) ?></p>
				                <select name=gruppo class="form-control" >
				                
				                <?php 
				                    if($this->datiModuloRegistrazione["gruppoObbligatorio"]!="si") {
				                        ?><option value=0><?= $this->gestoreTraduzioni->traduci("Nessun gruppo",$this->linguaCorrente) ?></option><?php
				                    }
				                    
				                    while($gruppo = $risGruppi->fetch_assoc()) {
				                        echo"<option value={$gruppo["id"]}>{$gruppo["nome"]}</option>";
				                    }
				                ?>
				                </select>
				            </div>
				        <?php
                                        }
                                        
                                        $paginaCondizioni = parent::getDb()->leggiSingolaRiga("geecB_contenuti",$datiCookie["paginaMaggioriInformazioni"]);
                                        echo"<div class=\"custom-control custom-checkbox mb-3\">
                                                <input type=\"checkbox\" class=\"custom-control-input\" id=\"accettoTerminiECondizioni\" name=\"accettoTerminiECondizioni\" > </input>
                                                <label for=\"accettoTerminiECondizioni\" class=\"custom-control-label\">Accetto i <a href=articolo.php?id={$paginaCondizioni["id"]}&alias={$paginaCondizioni["alias"]}>termini e condizioni</a></label>
                                            </div>";
                                        echo"<button type=\"submit\" class=\"btn btn-primary leggi-tutto\" onclick=\"controlloTerminiECondizioni()\"></span>Registrati </button>";
                                  echo"</div>";
                    echo"</form>
		</div>";
            echo"</div>"
            . "</div>";
        }
        
        // funzione che stampa il form di login
        function stampaModuloLogin($percorsoAdmin) {
            echo"<div class=\"col-md-6\" >
                    <div id=\"divEsitoLogin\"></div>
                    <div class=\"bg-primary text-white p-4 box-shadow-lite\">
                        <h5>Già registrato? Accedi subito</h5>
                        <form class=\"mt-3\" name=\"formLogin\" action=\"$percorsoAdmin/utenti/login.php\" method=\"post\">
                        <input type=\"text\" class=\"d-none\" name=\"operazione\" value=\"login\">";

                        echo"<div class=\"form-label-group\">
                               <input type=\"text\" class=\"form-control\" id=\"emailLogin\" name=\"email\" placeholder=\"Email\" required>
                               <label for=\"emailLogin\" >Email</label>
                           </div>";

                        echo"<div class=\"form-label-group\">
                               <input type=\"password\" class=\"form-control\" id=passwordLogin name=\"password\" placeholder=\" \" required>
                               <label for=\"passwordLogin\" >Password</label>
                           </div>";

                        echo"<button type=\"button\" class=\"btn btn-outline-light leggi-tutto\" onclick=\"document.formLogin.submit()\"></span>Accedi </button>";
                    echo"</form>
                    </div>
		</div>";  
        }
        
        // funzione che stampa il testo di benvenuto dell'utente
        function stampaBenvenuto($sessioneUtente) {
            $utente = parent::getDb()->leggiSingolaRiga("geec_utenti",$sessioneUtente);
            $nome = $utente["nome"];
            echo"<div class=col-md-6 >
            <h2>Benvenuto $nome</h2>";

            echo"<div class=\"form-group\">
                <div class=\"col-sm-offset-3 col-sm-9\">
                  <a href=areariservata/utenti/logout.php class=\"btn btn-primary\" onclick=\"loginPaginaCarrello()\"></span>Logout </a>
                  <a href=areariservata/pagina.php?id=2 class=\"btn btn-primary\" onclick=\"loginPaginaCarrello()\"></span>Profilo utente </a>
              </div></div>";
            echo"</div>";    
        }
        
        // Getter & setter
        public function getGestoreTraduzioni() {
            return $this->gestoreTraduzioni;
        }

        public function getLinguaCorrente() {
            return $this->linguaCorrente;
        }

        public function setGestoreTraduzioni($gestoreTraduzioni): void {
            $this->gestoreTraduzioni = $gestoreTraduzioni;
        }

        public function setLinguaCorrente($linguaCorrente): void {
            $this->linguaCorrente = $linguaCorrente;
        }
    }